#version 330
#extension GL_EXT_gpu_shader4 : enable
// Melty SDF Torus LatticeMod01.fsh  by   bio998

//https://www.shadertoy.com/view/MsfcDr
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.177  //*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

// If you came here to learn, I just began this so!  Check out the Cabbibo SDF tutorial:
// Well really it is Cabbibo's shader tutorial available at
// https://www.shadertoy.com/view/Xl2XWt

// Also using some of the following library
//                           HG_SDF
//
//     GLSL LIBRARY FOR BUILDING SIGNED DISTANCE BOUNDS
//
//     version 2016-01-10
//
//     Check http://mercury.sexy/hg_sdf for updates
//     and usage examples. Send feedback to spheretracing@mercury.sexy.
//
//     Brought to you by MERCURY http://mercury.sexy

//Also using code from for the torus sdf
// https://iquilezles.org/articles/distfunctions



// This calculation basically gets a way for us to 
// transform the rays coming out of our eyes and going through the window.
// If it doesn't make sense, thats ok. It doesn't make sense to me either :)
// Whats important to remember is that this basically gives us a way to position
// our window. We could you it to make the window look north, south, east, west, up, down
// or ANYWHERE in between!
mat3 calculateEyeRayTransformationMatrix( in vec3 ro, in vec3 ta, in float roll )
{
    vec3 ww = normalize( ta - ro );
    vec3 uu = normalize( cross(ww,vec3(sin(roll),cos(roll),0.0) ) );
    vec3 vv = normalize( cross(uu,ww));
    return mat3( uu, vv, ww );
}


//this is from
// Repeat space along one axis. Use like this to repeat along the x axis:
// <float cell = pMod1(p.x,5);> - using the return value is optional.
float pMod1(inout float p, float size) {
	float halfsize = size*0.5;
	float c = floor((p + halfsize)/size);
	p = mod(p + halfsize, size) - halfsize;
	return c;
}

// Shortcut for 45-degrees rotation
void pR45(inout vec2 p) {
	p = (p + vec2(p.y, -p.x))*sqrt(0.5);
}

//Union function from the SDF library
// The "Columns" flavour makes n-1 circular columns at a 45 degree angle:
float fOpUnionColumns(float a, float b, float r, float n) {
	if ((a < r) && (b < r)) {
		vec2 p = vec2(a, b);
		float columnradius = r*sqrt(2.)/((n-1.)*2.+sqrt(2.));
		pR45(p);
		p.x -= sqrt(2.)/2.*r;
		p.x += columnradius*sqrt(2.);
		if (mod(n,2.) == 1.) {
			p.y += columnradius;
		}
		// At this point, we have turned 45 degrees and moved at a point on the
		// diagonal that we want to place the columns on.
		// Now, repeat the domain along this direction and place a circle.
		pMod1(p.y, columnradius*2.);
		float result = length(p) - columnradius;
		result = min(result, p.x);
		result = min(result, a);
		return min(result, b);
	} else {
		return min(a, b);
	}
}




float sdTorus( vec3 p, vec2 t )
{
  //vec2 q = vec2(length(p.xz)-t.x,p.y);
  //return length(q)-t.y;
    
  vec2 q = vec2(length(p.xy)-t.x,p.z);
  return length(q)-t.y;
}


vec2 sdfTorus( vec3 currentRayPosition){
    
      currentRayPosition.x -= iTime * 0.3;
      currentRayPosition.z += iTime * 0.3;
      currentRayPosition.z -= iTime * 0.5;


  currentRayPosition.z -= 0.3;
      currentRayPosition.y -= 0.5;

    
    pMod1(currentRayPosition.x,1.);
    pMod1(currentRayPosition.y,1.);
    pMod1(currentRayPosition.z,1.);

    
    vec2 torusRadii = vec2(0.4,0.03);
    float torusID = 4.;
    
    vec2 torus = vec2( sdTorus(currentRayPosition,torusRadii), torusID);
    return torus;
    
}



float udRoundBox( vec3 p, vec3 b, float r ){

  return length(max(abs(p)-b,0.0))-r;
}

vec2 sdfRoundBox( vec3 currentRayPosition ){
    
  currentRayPosition.x -= sin(iTime) * 0.3;
  currentRayPosition.z -= iTime * 0.3;
  currentRayPosition.z -= iTime * 0.5;


  currentRayPosition.z -= 0.3;
  currentRayPosition.y -= 0.3;

  

    
  pMod1(currentRayPosition.x,1.);
  pMod1(currentRayPosition.y,0.6);
  pMod1(currentRayPosition.z,1.);
    
    
  
    
  float xpos = 0.3 * sin(iTime);
  
  // First we define our box position
  //vec3 boxPosition = vec3( -.8 , -.4 , 0.2 );
  vec3 boxPosition = vec3( xpos , 0.0 , 0.0 );
    
  // than we define our box dimensions using x , y and z
  vec3 boxSize = vec3( .08 );
    
  // Here we get the 'adjusted ray position' which is just
  // writing the point of the ray as if the origin of the 
  // space was where the box was positioned, instead of
  // at 0,0,0 . AKA the difference between the vectors in
  // vector format.
  vec3 adjustedRayPosition = currentRayPosition - boxPosition;
    
  // finally we get the distance to the box surface.
  // I don't get this part very much, but I bet Inigo does!
  // Thanks for making code for us IQ !
  vec3 distanceVec = abs( adjustedRayPosition ) - boxSize;
  float maxDistance = max( distanceVec.x , max( distanceVec.y , distanceVec.z ) ); 
  //float distanceToBoxSurface = min( maxDistance , 0.0 ) + length( max( distanceVec , 0.0 ) );
  
  vec3 zero = vec3(0.2);
  float distanceToBoxSurface = udRoundBox(adjustedRayPosition, boxSize, 0.05);
  
  // Finally we build the full box information, by giving it an ID
  float boxID = 3.;
    	
  // And there we have it! A fully described box!
  vec2 box = vec2( distanceToBoxSurface,  boxID );
    
  return box;
    
}

float smin( float a, float b)
{
   // float k = 0.77521;
        
    float k = 0.2521;

    float h = clamp( 0.5+0.5*(b-a)/k, 0.0, 1.0 );
    return mix( b, a, h ) - k*h*(1.0-h);
}


float opBlend( float d1, float d2)
{
    //float d1 = primitiveA(p);
    //float d2 = primitiveB(p);
    return smin( d1, d2 );
}

// 'TAG : WHICH AM I CLOSER TO?'
// This function takes in two things
// and says which is closer by using the 
// distance to each thing, comparing them
// and returning the one that is closer!
vec2 whichThingAmICloserTo( vec2 thing1 , vec2 thing2 ){
 
   vec2 closestThing;
    
   // Check out the balloon function
   // and remember how the x of the returned
   // information is the distance, and the y 
   // is the id of the thing!
   if( thing1.x <= thing2.x ){
       
   	   closestThing = thing1;
       
   }else if( thing2.x < thing1.x ){
       
       closestThing = thing2;
       
   }
 
   return closestThing;
    
}

    

// Takes in the position of the ray, and feeds back
// 2 values of how close it is to things in the world
// what thing it is closest two in the world.

vec2 mapTheWorld( vec3 currentRayPosition ){


  vec2 result;
    
  vec2 torus = sdfTorus( currentRayPosition );
  vec2 box     = sdfRoundBox( currentRayPosition );
        
  result = whichThingAmICloserTo( torus , box );
  //result.x = opBlend( torus.x, box.x);
    
  float chamferRadius = 0.15;
  float numberOfColumns = 3.;
  float colUnion =  fOpUnionColumns(torus.x, box.x, chamferRadius, numberOfColumns);
  result.x = colUnion;
    
  return result;


}



//---------------------------------------------------
// SECTION 'C' : NAVIGATING THE WORLD
//---------------------------------------------------

// We want to know when the closeness to things in the world is
// 0.0 , but if we wanted to get exactly to 0 it would take us
// alot of time to be that precise. Here we define the laziness
// our navigation function. try chaning the value to see what it does!
// if you are getting too low of framerates, this value will help alot,
// but can also make your scene look very different
// from how it should
const float HOW_CLOSE_IS_CLOSE_ENOUGH = 0.005;

// This is basically how big our scene is. each ray will be shot forward
// until it reaches this distance. the smaller it is, the quicker the 
// ray will reach the edge, which should help speed up this function
const float FURTHEST_OUR_RAY_CAN_REACH = 30.;

// This is how may steps our ray can take. Hopefully for this
// simple of a world, it will very quickly get to the 'close enough' value
// and stop the iteration, but for more complex scenes, this value
// will dramatically change not only how good the scene looks
// but how fast teh scene can render. 

// remember that for each pixel we are displaying, the 'mapTheWorld' function
// could be called this many times! Thats ALOT of calculations!!!
//const int HOW_MANY_STEPS_CAN_OUR_RAY_TAKE = 800;
const int HOW_MANY_STEPS_CAN_OUR_RAY_TAKE = 21;




vec2 checkRayHit( in vec3 eyePosition , in vec3 rayDirection ){

  //First we set some default values
 
  
  // our distance to surface will get overwritten every step,
  // so all that is important is that it is greater than our
  // 'how close is close enough' value
  float distanceToSurface 			= HOW_CLOSE_IS_CLOSE_ENOUGH * 2.;
    
  // The total distance traveled by the ray obviously should start at 0
  float totalDistanceTraveledByRay 	= 0.;
    
  // if we hit something, this value will be overwritten by the
  // totalDistance traveled, and if we don't hit something it will
  // be overwritten by the furthest our ray can reach,
  // so it can be whatever!
  float finalDistanceTraveledByRay 	= -1.;
    
  // if our id is less that 0. , it means we haven't hit anything
  // so lets start by saying we haven't hit anything!
  float finalID = -1.;

    
    
  //here is the loop where the magic happens
  for( int i = 0; i < HOW_MANY_STEPS_CAN_OUR_RAY_TAKE; i++ ){
      
    // First off, stop the iteration, if we are close enough to the surface!
    if( distanceToSurface < HOW_CLOSE_IS_CLOSE_ENOUGH ) break;
      
    // Second off, stop the iteration, if we have reached the end of our scene! 
    if( totalDistanceTraveledByRay > FURTHEST_OUR_RAY_CAN_REACH ) break;
    
    // To check how close we are to things in the world,
    // we need to get a position in the scene. to do this, 
    // we start at the rays origin, AKA the eye
    // and move along the ray direction, the amount we have already traveled.
    vec3 currentPositionOfRay = eyePosition + rayDirection * totalDistanceTraveledByRay;
    
    // Distance to and ID of things in the world
    //--------------------------------------------------------------
	// SECTION 'D' : MAPPING THE WORLD , AKA 'SDFS ARE AWESOME!!!!'
	//--------------------------------------------------------------
    vec2 distanceAndIDOfThingsInTheWorld = mapTheWorld( currentPositionOfRay );
      
      
 	// we get out the results from our mapping of the world
    // I am reassigning them for clarity
    float distanceToThingsInTheWorld = distanceAndIDOfThingsInTheWorld.x;
    float idOfClosestThingInTheWorld = distanceAndIDOfThingsInTheWorld.y;
     
    // We save out the distance to the surface, so that
    // next iteration we can check to see if we are close enough 
    // to stop all this silly iteration
    distanceToSurface           = distanceToThingsInTheWorld;
      
    // We are also finalID to the current closest id,
    // because if we hit something, we will have the proper
    // id, and we can skip reassigning it later!
    finalID = idOfClosestThingInTheWorld;  
     
    // ATTENTION: THIS THING IS AWESOME!
   	// This last little calculation is probably the coolest hack
    // of this entire tutorial. If we wanted too, we could basically 
    // step through the field at a constant amount, and at every step
    // say 'am i there yet', than move forward a little bit, and
    // say 'am i there yet', than move forward a little bit, and
    // say 'am i there yet', than move forward a little bit, and
    // say 'am i there yet', than move forward a little bit, and
    // say 'am i there yet', than move forward a little bit, and
    // that would take FOREVER, and get really annoying.
      
    // Instead what we say is 'How far until we are there?'
    // and move forward by that amount. This means that if
    // we are really far away from everything, we can make large
    // movements towards the surface, and if we are closer
    // we can make more precise movements. making our marching functino
    // faster, and ideally more precise!!
      
    // WOW!
      
    totalDistanceTraveledByRay += distanceToThingsInTheWorld;
      

  }

  // if we hit something set the finalDirastnce traveled by
  // ray to that distance!
  if( totalDistanceTraveledByRay < FURTHEST_OUR_RAY_CAN_REACH ){
  	finalDistanceTraveledByRay = totalDistanceTraveledByRay;
  }
    
    
  // If the total distance traveled by the ray is further than
  // the ray can reach, that means that we've hit the edge of the scene
  // Set the final distance to be the edge of the scene
  // and the id to -1 to make sure we know we haven't hit anything
  if( totalDistanceTraveledByRay > FURTHEST_OUR_RAY_CAN_REACH ){ 
  	finalDistanceTraveledByRay = FURTHEST_OUR_RAY_CAN_REACH;
    finalID = -1.;
  }

  return vec2( finalDistanceTraveledByRay , finalID ); 

}







//--------------------------------------------------------------
// SECTION 'E' : COLORING THE WORLD
//--------------------------------------------------------------



// Here we are calcuting the normal of the surface
// Although it looks like alot of code, it actually
// is just trying to do something very simple, which
// is to figure out in what direction the SDF is increasing.
// What is amazing, is that this value is the same thing 
// as telling you what direction the surface faces, AKA the
// normal of the surface. 
vec3 getNormalOfSurface( in vec3 positionOfHit ){
    
	vec3 tinyChangeX = vec3( 0.001, 0.0, 0.0 );
    vec3 tinyChangeY = vec3( 0.0 , 0.001 , 0.0 );
    vec3 tinyChangeZ = vec3( 0.0 , 0.0 , 0.001 );
    
   	float upTinyChangeInX   = mapTheWorld( positionOfHit + tinyChangeX ).x; 
    float downTinyChangeInX = mapTheWorld( positionOfHit - tinyChangeX ).x; 
    
    float tinyChangeInX = upTinyChangeInX - downTinyChangeInX;
    
    
    float upTinyChangeInY   = mapTheWorld( positionOfHit + tinyChangeY ).x; 
    float downTinyChangeInY = mapTheWorld( positionOfHit - tinyChangeY ).x; 
    
    float tinyChangeInY = upTinyChangeInY - downTinyChangeInY;
    
    
    float upTinyChangeInZ   = mapTheWorld( positionOfHit + tinyChangeZ ).x; 
    float downTinyChangeInZ = mapTheWorld( positionOfHit - tinyChangeZ ).x; 
    
    float tinyChangeInZ = upTinyChangeInZ - downTinyChangeInZ;
    
    
	vec3 normal = vec3(
         			tinyChangeInX,
        			tinyChangeInY,
        			tinyChangeInZ
    	 		  );
    
	return normalize(normal);
}





// doing our background color is easy enough,
// just make it pure black. like my soul.
vec3 doBackgroundColor(){
	return vec3( 0.1,0.2,0.2 );
}




vec3 doBalloonColor(vec3 positionOfHit , vec3 normalOfSurface ){
    
    vec3 sunPosition = vec3( 4. , 1. , 3. );
    
    // the direction of the light goes from the sun
    // to the position of the hit
    vec3 lightDirection = sunPosition - positionOfHit;
   	
    
    // Here we are 'normalizing' the light direction
   	// because we don't care how long it is, we
    // only care what direction it is!
    lightDirection = normalize( lightDirection );
    
    
    // getting the value of how much the surface
    // faces the light direction
    float faceValue = dot( lightDirection , normalOfSurface );
	
    // if the face value is negative, just make it 0.
    // so it doesn't give back negative light values
    // cuz that doesn't really make sense...
    faceValue = max( 0. , faceValue );
    
    vec3 balloonColor = vec3( 0.8 , 0.8 , 0.8 );
    
   	// our final color is the balloon color multiplied
    // by how much the surface faces the light
    vec3 color = balloonColor * faceValue;
    
    // add in a bit of ambient color
    // just so we don't get any pure black
    color += vec3( .1 , .14, .1 );
    
    
	return color;
}


vec3 doCurveBoxColor(vec3 positionOfHit , vec3 normalOfSurface ){
    
    vec3 sunPosition = vec3( 4. , 1. , 3. );
    
    // the direction of the light goes from the sun
    // to the position of the hit
    vec3 lightDirection = sunPosition - positionOfHit;
   	
    
    // Here we are 'normalizing' the light direction
   	// because we don't care how long it is, we
    // only care what direction it is!
    lightDirection = normalize( lightDirection );
    
    
    // getting the value of how much the surface
    // faces the light direction
    float faceValue = dot( lightDirection , normalOfSurface );
	
    // if the face value is negative, just make it 0.
    // so it doesn't give back negative light values
    // cuz that doesn't really make sense...
    faceValue = max( 0. , faceValue );
    
    vec3 balloonColor = vec3( 0.9 , 0.9 , 0.9 );
    
   	// our final color is the balloon color multiplied
    // by how much the surface faces the light
    vec3 color = balloonColor * faceValue;
    
    // add in a bit of ambient color
    // just so we don't get any pure black
    color += vec3( .1 , .14, .1 );
    
    
	return color;
}

vec3 doTorusColor(vec3 positionOfHit, vec3 normalOfSurface){
    
    vec3 sunPosition = vec3( 4. , 1. , 3. );
    
    // the direction of the light goes from the sun
    // to the position of the hit
    vec3 lightDirection = sunPosition - positionOfHit;
   	
    
    // Here we are 'normalizing' the light direction
   	// because we don't care how long it is, we
    // only care what direction it is!
    lightDirection = normalize( lightDirection );
    
    
    // getting the value of how much the surface
    // faces the light direction
    float faceValue = dot( lightDirection , normalOfSurface );
	
    // if the face value is negative, just make it 0.
    // so it doesn't give back negative light values
    // cuz that doesn't really make sense...
    faceValue = max( 0. , faceValue );
    
    vec3 torusColor = vec3( 1. , .4 , 0.3 );
    
   	// our final color is the balloon color multiplied
    // by how much the surface faces the light
    vec3 color = torusColor * faceValue;
    
    // add in a bit of ambient color
    // just so we don't get any pure black
    color += vec3( .1 , .14, .1 );
    
    
	return color;
    
}



// Here we are using the normal of the surface,
// and mapping it to color, to show you just how cool
// normals can be!
vec3 doBoxColor(vec3 positionOfHit , vec3 normalOfSurface ){
    
    vec3 color = vec3( normalOfSurface.x , normalOfSurface.y , normalOfSurface.z );
    
    //could also just write color = normalOfSurce
    //but trying to be explicit.
    
	return color;
}




// This is where we decide
// what color the world will be!
// and what marvelous colors it will be!
vec3 colorTheWorld( vec2 rayHitInfo , vec3 eyePosition , vec3 rayDirection ){
   
  // remember for color
  // x = red , y = green , z = blue
  vec3 color;
    
  // THE LIL RAY WENT ALL THE WAY
  // TO THE EDGE OF THE WORLD, 
  // AND DIDN'T HIT ANYTHING
  if( rayHitInfo.y < 0.0 ){
      
  	color = doBackgroundColor();  
     
      
  // THE LIL RAY HIT SOMETHING!!!!
  }else{
      
      // If we hit something, 
      // we also know how far the ray has to travel to hit it
      // and because we know the direction of the ray, we can
      // get the exact position of where we hit the surface
      // by following the ray from the eye, along its direction
      // for the however far it had to travel to hit something
      vec3 positionOfHit = eyePosition + rayHitInfo.x * rayDirection;
      
      // We can then use this information to tell what direction
      // the surface faces in
      vec3 normalOfSurface = getNormalOfSurface( positionOfHit );
      
      
      // 1.0 is the Balloon ID
      if( rayHitInfo.y == 1.0 ){
          
  		color = doBalloonColor( positionOfHit , normalOfSurface ); 
       
          
      // 2.0 is the Box ID
      }else if( rayHitInfo.y == 2.0 ){
          
      	color = doBoxColor( positionOfHit , normalOfSurface );   
          
      }else if( rayHitInfo.y == 3.0 ){
          
      	color = doCurveBoxColor( positionOfHit , normalOfSurface );   
          
      }else if( rayHitInfo.y == 4.0 ){
          
      	color = doTorusColor( positionOfHit , normalOfSurface );   
          
      }
 
  
  }
    
    
    return color;
    
    
}


void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    
    //---------------------------------------------------
    // SECTION 'A' : ONE PROGRAM FOR EVERY PIXEL!
    //---------------------------------------------------
    
    // Here we are getting our 'Position' of each pixel
    // This section is important, because if we didn't
    // divied by the resolution, our values would be masssive
    // as gl_FragCoord.xy returns the value of how many pixels over we 
    // are. which is alot :)
	vec2 p = ( -iResolution.xy + 2.0 * gl_FragCoord.xy ) / iResolution.y;
     
    // thats a super long name, so maybe we will 
    // keep on using uv, but im explicitly defining it
    // so you can see exactly what those two letters mean
    vec2 xyPositionOfPixelInWindow = p;
    
    
    
    //---------------------------------------------------
    // SECTION 'B' : BUILDING THE WINDOW
    //---------------------------------------------------
    
    // We use the eye position to tell use where the viewer is
    vec3 eyePosition = vec3( 0., 0., 2.);
    
    // This is the point the view is looking at. 
    // The window will be placed between the eye, and the 
    // position the eye is looking at!
    vec3 pointWeAreLookingAt = vec3( 0. , 0. , 0. );
  
	// This is where the magic of actual mathematics
    // gives a way to actually place the window.
    // the 0. at the end there gives the 'roll' of the transformation
    // AKA we would be standing so up is up, but up could be changing 
    // like if we were one of those creepy dolls whos rotate their head
    // all the way around along the z axis
    mat3 eyeTransformationMatrix = calculateEyeRayTransformationMatrix( eyePosition , pointWeAreLookingAt , 0. ); 
   
    
    // Here we get the actual ray that goes out of the eye
    // and through the individual pixel! This basically the only thing
    // that is different between the pixels, but is also the bread and butter
    // of ray tracing. It should be since it has the word 'ray' in its variable name...
    // the 2. at the end is the 'lens length' . I don't know how to best
    // describe this, but once the full scene is built, tryin playing with it
    // to understand inherently how it works
    vec3 rayComingOutOfEyeDirection = normalize( eyeTransformationMatrix * vec3( p.xy , 2. ) ); 

    
    
    //---------------------------------------------------
	// SECTION 'C' : NAVIGATING THE WORLD
	//---------------------------------------------------
    vec2 rayHitInfo = checkRayHit( eyePosition , rayComingOutOfEyeDirection );
    
    
    //--------------------------------------------------------------
	// SECTION 'E' : COLORING THE WORLD
	//--------------------------------------------------------------
	vec3 color = colorTheWorld( rayHitInfo , eyePosition , rayComingOutOfEyeDirection );
    
   
   	//--------------------------------------------------------------
    // SECTION 'F' : Wrapping up
    //--------------------------------------------------------------
	gl_FragColor = vec4(color,1.0);
    
    
    // WOW! WOW! WOW! WOW! WOW! WOW! WOW! WOW! WOW! WOW! WOW! WOW!
    // WOW! WOW! WOW! WOW! WOW! WOW! WOW! WOW! WOW! WOW! WOW! WOW! 
    // WOW! WOW! WOW! WOW! WOW! WOW! WOW! WOW! WOW! WOW! WOW! WOW! 
    // WOW! WOW! WOW! WOW! WOW! WOW! WOW! WOW! WOW! WOW! WOW! WOW! 
    // WOW! WOW! WOW! WOW! WOW! WOW! WOW! WOW! WOW! WOW! WOW! WOW! 
    
    
}

